// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Indnsresolver.pas' rev: 10.00

#ifndef IndnsresolverHPP
#define IndnsresolverHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Inassignednumbers.hpp>	// Pascal unit
#include <Inbuffer.hpp>	// Pascal unit
#include <Incomponent.hpp>	// Pascal unit
#include <Inglobal.hpp>	// Pascal unit
#include <Inexceptioncore.hpp>	// Pascal unit
#include <Innetworkcalculator.hpp>	// Pascal unit
#include <Inglobalprotocols.hpp>	// Pascal unit
#include <Indnscommon.hpp>	// Pascal unit
#include <Intcpclient.hpp>	// Pascal unit
#include <Intcpconnection.hpp>	// Pascal unit
#include <Inudpclient.hpp>	// Pascal unit
#include <Inbasecomponent.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Indnsresolver
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TQueryRecordTypes { qtA, qtNS, qtMD, qtMF, qtName, qtSOA, qtMB, qtMG, qtMR, qtNull, qtWKS, qtPTR, qtHINFO, qtMINFO, qtMX, qtTXT, qtAAAA, qtAXFR, qtSTAR, qtUnknown };
#pragma option pop

#pragma option push -b-
enum TXFRTypes { xtAXFR, xtIXFR };
#pragma option pop

typedef Set<TQueryRecordTypes, qtA, qtUnknown>  TQueryType;

class DELPHICLASS TResultRecord;
class PASCALIMPLEMENTATION TResultRecord : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
protected:
	TQueryRecordTypes FRecType;
	Word FRecClass;
	AnsiString FName;
	unsigned FTTL;
	DynamicArray<Byte >  FRData;
	int FRDataLength;
	
public:
	virtual void __fastcall Parse(Inglobal::TBytes CompleteMessage, int APos);
	__property TQueryRecordTypes RecType = {read=FRecType, nodefault};
	__property Word RecClass = {read=FRecClass, nodefault};
	__property AnsiString Name = {read=FName};
	__property unsigned TTL = {read=FTTL, nodefault};
	__property int RDataLength = {read=FRDataLength, nodefault};
	__property Inglobal::TBytes RData = {read=FRData};
	__fastcall virtual ~TResultRecord(void);
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TResultRecord(Classes::TCollection* Collection) : Classes::TCollectionItem(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TRDATARecord;
class PASCALIMPLEMENTATION TRDATARecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	AnsiString FIPAddress;
	
public:
	virtual void __fastcall Parse(Inglobal::TBytes CompleteMessage, int APos);
	__fastcall virtual TRDATARecord(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property AnsiString IPAddress = {read=FIPAddress};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TRDATARecord(void) { }
	#pragma option pop
	
};


class DELPHICLASS TARecord;
class PASCALIMPLEMENTATION TARecord : public TRDATARecord 
{
	typedef TRDATARecord inherited;
	
public:
	#pragma option push -w-inl
	/* TRDATARecord.Create */ inline __fastcall virtual TARecord(Classes::TCollection* Collection) : TRDATARecord(Collection) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TARecord(void) { }
	#pragma option pop
	
};


class DELPHICLASS TAAAARecord;
class PASCALIMPLEMENTATION TAAAARecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	AnsiString FAddress;
	
public:
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__fastcall virtual TAAAARecord(Classes::TCollection* Collection);
	virtual void __fastcall Parse(Inglobal::TBytes CompleteMessage, int APos);
	__property AnsiString Address = {read=FAddress};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TAAAARecord(void) { }
	#pragma option pop
	
};


class DELPHICLASS TWKSRecord;
class PASCALIMPLEMENTATION TWKSRecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	int FByteCount;
	DynamicArray<Byte >  FData;
	AnsiString FIPAddress;
	Word FProtocol;
	Byte __fastcall GetABit(int AIndex);
	
public:
	virtual void __fastcall Parse(Inglobal::TBytes CompleteMessage, int APos);
	__property AnsiString IPAddress = {read=FIPAddress};
	__property Word Protocol = {read=FProtocol, nodefault};
	__property Byte BitMap[int index] = {read=GetABit};
	__property int ByteCount = {read=FByteCount, nodefault};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TWKSRecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TWKSRecord(Classes::TCollection* Collection) : TResultRecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TMXRecord;
class PASCALIMPLEMENTATION TMXRecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	AnsiString FExchangeServer;
	Word FPreference;
	
public:
	virtual void __fastcall Parse(Inglobal::TBytes CompleteMessage, int APos);
	__fastcall virtual TMXRecord(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property AnsiString ExchangeServer = {read=FExchangeServer};
	__property Word Preference = {read=FPreference, nodefault};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TMXRecord(void) { }
	#pragma option pop
	
};


class DELPHICLASS TTextRecord;
class PASCALIMPLEMENTATION TTextRecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	Classes::TStrings* FText;
	
public:
	__fastcall virtual TTextRecord(Classes::TCollection* Collection);
	__fastcall virtual ~TTextRecord(void);
	virtual void __fastcall Parse(Inglobal::TBytes CompleteMessage, int APos);
	__property Classes::TStrings* Text = {read=FText};
};


class DELPHICLASS THINFORecord;
class PASCALIMPLEMENTATION THINFORecord : public TTextRecord 
{
	typedef TTextRecord inherited;
	
protected:
	AnsiString FCPU;
	AnsiString FOS;
	
public:
	virtual void __fastcall Parse(Inglobal::TBytes CompleteMessage, int APos);
	__property AnsiString CPU = {read=FCPU};
	__property AnsiString OS = {read=FOS};
public:
	#pragma option push -w-inl
	/* TTextRecord.Create */ inline __fastcall virtual THINFORecord(Classes::TCollection* Collection) : TTextRecord(Collection) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TTextRecord.Destroy */ inline __fastcall virtual ~THINFORecord(void) { }
	#pragma option pop
	
};


class DELPHICLASS TMINFORecord;
class PASCALIMPLEMENTATION TMINFORecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	AnsiString FResponsiblePerson;
	AnsiString FErrorMailbox;
	
public:
	virtual void __fastcall Parse(Inglobal::TBytes CompleteMessage, int APos);
	__property AnsiString ResponsiblePersonMailbox = {read=FResponsiblePerson};
	__property AnsiString ErrorMailbox = {read=FErrorMailbox};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TMINFORecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TMINFORecord(Classes::TCollection* Collection) : TResultRecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TSOARecord;
class PASCALIMPLEMENTATION TSOARecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	unsigned FSerial;
	unsigned FMinimumTTL;
	unsigned FRefresh;
	unsigned FRetry;
	AnsiString FMNAME;
	AnsiString FRNAME;
	unsigned FExpire;
	
public:
	virtual void __fastcall Parse(Inglobal::TBytes CompleteMessage, int APos);
	__property AnsiString Primary = {read=FMNAME};
	__property AnsiString ResponsiblePerson = {read=FRNAME};
	__property unsigned Serial = {read=FSerial, nodefault};
	__property unsigned Refresh = {read=FRefresh, nodefault};
	__property unsigned Retry = {read=FRetry, nodefault};
	__property unsigned Expire = {read=FExpire, nodefault};
	__property unsigned MinimumTTL = {read=FMinimumTTL, nodefault};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TSOARecord(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TSOARecord(Classes::TCollection* Collection) : TResultRecord(Collection) { }
	#pragma option pop
	
};


class DELPHICLASS TNAMERecord;
class PASCALIMPLEMENTATION TNAMERecord : public TResultRecord 
{
	typedef TResultRecord inherited;
	
protected:
	AnsiString FHostName;
	
public:
	virtual void __fastcall Parse(Inglobal::TBytes CompleteMessage, int APos);
	__fastcall virtual TNAMERecord(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property AnsiString HostName = {read=FHostName};
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TNAMERecord(void) { }
	#pragma option pop
	
};


class DELPHICLASS TNSRecord;
class PASCALIMPLEMENTATION TNSRecord : public TNAMERecord 
{
	typedef TNAMERecord inherited;
	
public:
	#pragma option push -w-inl
	/* TNAMERecord.Create */ inline __fastcall virtual TNSRecord(Classes::TCollection* Collection) : TNAMERecord(Collection) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TNSRecord(void) { }
	#pragma option pop
	
};


class DELPHICLASS TCNRecord;
class PASCALIMPLEMENTATION TCNRecord : public TNAMERecord 
{
	typedef TNAMERecord inherited;
	
public:
	#pragma option push -w-inl
	/* TNAMERecord.Create */ inline __fastcall virtual TCNRecord(Classes::TCollection* Collection) : TNAMERecord(Collection) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TCNRecord(void) { }
	#pragma option pop
	
};


class DELPHICLASS TQueryResult;
class PASCALIMPLEMENTATION TQueryResult : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
public:
	TResultRecord* operator[](int Index) { return Items[Index]; }
	
protected:
	TResultRecord* FRec;
	AnsiString FDomainName;
	Word FQueryClass;
	Word FQueryType;
	Classes::TStringList* FQueryPointerList;
	AnsiString __fastcall DNSStrToDomain(Inglobal::TBytes SrcStr, int &Idx);
	AnsiString __fastcall NextDNSLabel(Inglobal::TBytes DNSStr, int &APos);
	HIDESBASE void __fastcall SetItem(int Index, TResultRecord* Value);
	HIDESBASE TResultRecord* __fastcall GetItem(int Index);
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	
public:
	__fastcall TQueryResult(TResultRecord* AResultRecord);
	__fastcall virtual ~TQueryResult(void);
	HIDESBASE TResultRecord* __fastcall Add(Inglobal::TBytes Answer, int &APos);
	HIDESBASE void __fastcall Clear(void);
	__property Word QueryClass = {read=FQueryClass, nodefault};
	__property Word QueryType = {read=FQueryType, nodefault};
	__property AnsiString DomainName = {read=FDomainName};
	__property TResultRecord* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
};


class DELPHICLASS TPTRRecord;
class PASCALIMPLEMENTATION TPTRRecord : public TNAMERecord 
{
	typedef TNAMERecord inherited;
	
public:
	#pragma option push -w-inl
	/* TNAMERecord.Create */ inline __fastcall virtual TPTRRecord(Classes::TCollection* Collection) : TNAMERecord(Collection) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TResultRecord.Destroy */ inline __fastcall virtual ~TPTRRecord(void) { }
	#pragma option pop
	
};


class DELPHICLASS TInDNSResolver;
class PASCALIMPLEMENTATION TInDNSResolver : public Intcpconnection::TInTCPConnection 
{
	typedef Intcpconnection::TInTCPConnection inherited;
	
protected:
	Indnscommon::TDNSHeader* FDNSHeader;
	bool FAllowRecursiveQueries;
	DynamicArray<Byte >  FInternalQuery;
	int FQuestionLength;
	AnsiString FHost;
	Inglobal::TIdIPVersion FIPVersion;
	int FPort;
	TQueryResult* FQueryResult;
	TQueryType FQuertType;
	TXFRTypes FXFRType;
	int FWaitingTime;
	DynamicArray<Byte >  FPlainTextResult;
	void __fastcall SetAllowRecursiveQueries(const bool Value);
	void __fastcall SetHost(const AnsiString Value);
	void __fastcall SetQuertType(const TQueryType Value);
	void __fastcall SetXFRType(const TXFRTypes Value);
	void __fastcall SetWaitingTime(const int Value);
	void __fastcall SetInternalQuery(const Inglobal::TBytes Value);
	void __fastcall SetPlainTextResult(const Inglobal::TBytes Value);
	virtual void __fastcall InitComponent(void);
	virtual void __fastcall SetIPVersion(const Inglobal::TIdIPVersion AValue);
	Inglobal::TIdIPVersion __fastcall GetIPVersion(void);
	int __fastcall GetPort(void);
	virtual void __fastcall SetPort(const int AValue);
	
public:
	void __fastcall ClearInternalQuery(void);
	__fastcall virtual ~TInDNSResolver(void);
	void __fastcall ParseAnswers(Indnscommon::TDNSHeader* DNSHeader, Inglobal::TBytes Answer, unsigned AnswerNum, bool ResetResult = true);
	void __fastcall CreateQuery(AnsiString ADomain);
	void __fastcall FillResult(Inglobal::TBytes AResult, bool checkID = true, bool ResetResult = true);
	void __fastcall Resolve(AnsiString ADomain);
	__property TQueryResult* QueryResult = {read=FQueryResult};
	__property Inglobal::TBytes InternalQuery = {read=FInternalQuery, write=SetInternalQuery};
	__property Inglobal::TBytes PlainTextResult = {read=FPlainTextResult, write=SetPlainTextResult};
	
__published:
	__property TQueryType QueryType = {read=FQuertType, write=SetQuertType, nodefault};
	__property int WaitingTime = {read=FWaitingTime, write=SetWaitingTime, nodefault};
	__property TXFRTypes XFRType = {read=FXFRType, write=SetXFRType, nodefault};
	__property bool AllowRecursiveQueries = {read=FAllowRecursiveQueries, write=SetAllowRecursiveQueries, nodefault};
	__property AnsiString Host = {read=FHost, write=SetHost};
	__property int Port = {read=FPort, write=FPort, default=53};
	__property Inglobal::TIdIPVersion IPVersion = {read=GetIPVersion, write=SetIPVersion, nodefault};
public:
	#pragma option push -w-inl
	/* TInBaseComponent.Create */ inline __fastcall TInDNSResolver(Classes::TComponent* AOwner)/* overload */ : Intcpconnection::TInTCPConnection(AOwner) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE Word QueryRecordValues[19];
extern PACKAGE TQueryRecordTypes QueryRecordTypes[19];

}	/* namespace Indnsresolver */
using namespace Indnsresolver;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Indnsresolver
